import { Pressable } from "react-native";
import React from "react";
import ProgressiveImage from "../../../../../src/components/ProgressiveImage";
import CustomPhotoGallery from "../../../../../src/components/CustomImageGallery/CustomPhotoGallery";
import { useState } from "react";
import { ratingAndReviewsStyle } from "./RatingAndReviewsStyle";

const ReviewImages = ({ image, index, data, imageStyle }) => {
    const [isOpenGallery, setIsOpenGallery] = useState(false);
    return (
        <>
            <Pressable
                onPress={() => {
                    setIsOpenGallery(true);
                }}
            >
                <ProgressiveImage
                    source={{ uri: image }}
                    style={[
                        ratingAndReviewsStyle.reviewImg,
                        imageStyle,
                    ]}
                />
            </Pressable>
            <CustomPhotoGallery
                isOpen={isOpenGallery}
                setIsOpen={setIsOpenGallery}
                images={data}
                index={index}
            />
        </>
    );
};

export default ReviewImages;
